{ *********************************************************************** }
{                                                                         }
{ Delphi Visual Component Library                                         }
{                                                                         }
{ Copyright (c) 2003-2004 Borland Software Corporation                    }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.NetControl platform experimental;

{$T-,H+,X+}

interface

uses
  System.Windows.Forms,
  Borland.Vcl.NetActivator,
  Borland.Vcl.NetControlContainer;

{ TNetControl }

type  
  TNetControl = class(TNetControlContainer)
  private
    FActivator: TNetControlActivator;
    procedure OnControlActivate(Sender: TObject);
  protected  
    procedure Init; override;
  public
    property Activator: TNetControlActivator read FActivator;
  end;
  
implementation

uses
  Borland.Vcl.Classes;

{ TNetControl }

procedure TNetControl.Init;
begin
  FActivator := TNetControlActivator.Create(Self);
  FActivator.OnActivate := Self.OnControlActivate;
end;

procedure TNetControl.OnControlActivate(Sender: TObject);
begin
  Self.Control := FActivator.Control;
  if csDesigning in ComponentState then
    if (Self.Control.Text = '') then
      Self.Control.Text := Self.Name;
    
end;

end.

